#include <bits/stdc++.h>
#include <ext/pb_ds/tree_policy.hpp>
#include <ext/pb_ds/assoc_container.hpp>

const int MEM_SIZE = 1e8;
char MEM[MEM_SIZE];
int MEM_POS = 0;
void* operator new(size_t n) {
    assert(MEM_POS + n < MEM_SIZE);
    MEM_POS += n;
    return MEM + MEM_POS - n;
}
void operator delete(void* p) {}
void operator delete(void* p, size_t n) {}

using namespace std;
using ll = long long;
using ld = long double;

ofstream debug;

template <typename T, typename CMP = less<T>>
using ordered_set =__gnu_pbds::tree<T,
    __gnu_pbds::null_type,
    CMP,
    __gnu_pbds::rb_tree_tag,
    __gnu_pbds::tree_order_statistics_node_update>;

template <typename T>
struct Vector {
    T x, y;
    Vector(T x, T y): x(x), y(y) {}
    Vector(): Vector(0, 0) {}
};

template <typename T>
Vector<T> operator+(Vector<T> a, Vector<T> b) {
    return {a.x + b.x, a.y + b.y};
}
template <typename T>
Vector<T> operator-(Vector<T> a, Vector<T> b) {
    return {a.x - b.x, a.y - b.y};
}
template <typename T>
Vector<T> operator-(Vector<T> a) {
    return {-a.x, -a.y};
}
template <typename T>
Vector<T> operator*(Vector<T> a, T k) {
    return {a.x * k, a.y * k};
}
template <typename T>
Vector<T> operator*(T k, Vector<T> a) {
    return {a.x * k, a.y * k};
}
template <typename T>
Vector<T> operator/(Vector<T> a, T k) {
    return {a.x / k, a.y / k};
}
template <typename T>
T operator*(Vector<T> a, Vector<T> b) {
    return a.x * b.x + a.y * b.y;
}
template <typename T>
T operator%(Vector<T> a, Vector<T> b) {
    return a.x * b.y - a.y * b.x;
}


int main() {
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
    debug.open("debug.txt");
#endif
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int t;
    cin >> t;
    vector<ll> to_check;
    while (t--) {
        ll x, y;
        cin >> x >> y;
        if (y % x == 0) {
            cout << 0 << "\n";
            continue;
        }
        ll i = 1;
        ll n = y - x;
        for (; i <= n / i; i++) {
            if (n % i == 0) {
                to_check.push_back(i);
                if (i * i != n) to_check.push_back(n / i);
            }
        }
        ll best = x;
        for (ll e: to_check) {
            if (x - e >= 0) {
                debug << x - e << " ";
                best = min(best, x - e);
            }
        }
        debug << "\n";
        cout << best << "\n";
        to_check.clear();
    }
    return 0;
}